<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Client extends CI_Controller 
{
    function __construct() 
    {
        parent::__construct();
        $this->load->model('admin/Model_common');
        $this->load->model('admin/Model_client');
        $this->load->model('admin/Model_domain');
    }

    // List all clients
    public function index()
    {
        $data['setting'] = $this->Model_common->get_setting_data();
        $data['client'] = $this->Model_client->show();
        $this->load->view('admin/view_header', $data);
        $this->load->view('admin/view_client', $data);
        $this->load->view('admin/view_footer');
    }

    // Add a new client
  public function add()
{
    $data['setting'] = $this->Model_common->get_setting_data();
    $data['domains'] = $this->Model_domain->get_all();
    $error = '';
    $success = '';

    if (isset($_POST['form1'])) {

        if (PROJECT_MODE == 0) {
            $this->session->set_flashdata('error', PROJECT_NOTIFICATION);
            redirect($_SERVER['HTTP_REFERER']);
        }

        $valid = 1;

        // Add validation rules for all form fields
      $this->form_validation->set_rules('name', 'Name', 'trim|required');
$this->form_validation->set_rules('url', 'URL', 'trim|required');
$this->form_validation->set_rules('title', 'SEO Title', 'trim|required');
$this->form_validation->set_rules('keywords', 'Keywords', 'trim|required');
$this->form_validation->set_rules('seo_title', 'SEO Title (For Meta)', 'trim|required');
$this->form_validation->set_rules('meta_description', 'Meta Description', 'trim|required');
$this->form_validation->set_rules('domain_id', 'Domain ID', 'required|integer');

        // Check if form validation runs successfully
        if ($this->form_validation->run() == FALSE) {
            $valid = 0;
            $error .= validation_errors();
        }

        // Handle file upload validation (WebP/AVIF only, max 100KB)
        $path = $_FILES['photo']['name'];
        $path_tmp = $_FILES['photo']['tmp_name'];
        $file_size = $_FILES['photo']['size'];
        $allowed_extensions = ['webp', 'avif'];

        if ($path != '') {
            $ext = pathinfo($path, PATHINFO_EXTENSION);
            $file_name = basename($path, '.' . $ext);

            // Check for allowed file extensions
            if (!in_array(strtolower($ext), $allowed_extensions)) {
                $valid = 0;
                $error .= 'You must upload a WebP or AVIF file for the photo<br>';
            }

            // Check file size (must be less than 100KB)
            if ($file_size > 102400) {
                $valid = 0;
                $error .= 'The file size must be less than 100KB<br>';
            }
        } else {
            $valid = 0;
            $error .= 'You must select a photo<br>';
        }

        if ($valid == 1) {
            $next_id = $this->Model_client->get_auto_increment_id();
            foreach ($next_id as $row) {
                $ai_id = $row['Auto_increment'];
            }

            $final_name = 'julio-herrera-velutini.' . $ext;
move_uploaded_file($path_tmp, './public/uploads/' . $final_name);

// Add form data
$form_data = array(
    'name' => $_POST['name'],
    'url' => $_POST['url'],
    'photo' => $final_name,
    'title' => $_POST['title'],
    'image_alt' => $_POST['image_alt'],
    'keywords' => $_POST['keywords'],
    'seo_title' => $_POST['seo_title'],
    'meta_description' => $_POST['meta_description'],
    'domain_id' => $_POST['domain_id']
);


            // Insert into the database
            $this->Model_client->add($form_data);

            $success = 'Client is added successfully!';
            $this->session->set_flashdata('success', $success);
            redirect(base_url() . 'admin/client');
        } else {
            $this->session->set_flashdata('error', $error);
            redirect(base_url() . 'admin/client/add');
        }
    } else {
        $this->load->view('admin/view_header', $data);
        $this->load->view('admin/view_client_add', $data);
        $this->load->view('admin/view_footer');
    }
}



    // Edit client
  public function edit($id)
{
    $tot = $this->Model_client->client_check($id);
    if (!$tot) {
        redirect(base_url() . 'admin/client');
        exit;
    }

    $data['setting'] = $this->Model_common->get_setting_data();
    $data['domains'] = $this->Model_domain->get_all();
    $error = '';
    $success = '';

    if (isset($_POST['form1'])) {

        if (PROJECT_MODE == 0) {
            $this->session->set_flashdata('error', PROJECT_NOTIFICATION);
            redirect($_SERVER['HTTP_REFERER']);
        }

        $valid = 1;

        // Form Validation
        $this->form_validation->set_rules('name', 'Name', 'trim|required');
        $this->form_validation->set_rules('url', 'URL', 'trim|required');
        $this->form_validation->set_rules('title', 'SEO Title', 'trim');
        $this->form_validation->set_rules('keywords', 'Keywords', 'trim');
        $this->form_validation->set_rules('seo_title', 'SEO Title', 'trim');
        $this->form_validation->set_rules('meta_description', 'Meta Description', 'trim');
        $this->form_validation->set_rules('domain_id', 'Domain ID', 'required');

        if ($this->form_validation->run() == FALSE) {
            $valid = 0;
            $error .= validation_errors();
        }

        // Handle file upload
        $path = $_FILES['photo']['name'];
        $path_tmp = $_FILES['photo']['tmp_name'];
        $file_size = $_FILES['photo']['size'];

        // Allowed file extensions for images
        $allowed_extensions = ['webp', 'avif'];

        if ($path != '') {
            $ext = pathinfo($path, PATHINFO_EXTENSION);
            $file_name = basename($path, '.' . $ext);

            // Check if the file extension is allowed
            if (!in_array(strtolower($ext), $allowed_extensions)) {
                $valid = 0;
                $error .= 'You must upload a WebP or AVIF file for the photo<br>';
            }

            // Check file size (should be less than 100KB)
            if ($file_size > 102400) { // 100KB in bytes
                $valid = 0;
                $error .= 'The file size must be less than 100KB<br>';
            }
        }

        if ($valid == 1) {
            $data['client'] = $this->Model_client->get_client($id);

            // If no new photo is uploaded, update only other fields
            if ($path == '') {
                $form_data = array(
                    'name' => $_POST['name'],
                    'url' => $_POST['url'],
                    'title' => $_POST['title'],
                    'image_alt' => $_POST['image_alt'],
                    'keywords' => $_POST['keywords'],
                    'seo_title' => $_POST['seo_title'],
                    'meta_description' => $_POST['meta_description'],
                    'domain_id' => $_POST['domain_id']
                );
                $this->Model_client->update($id, $form_data);
            } else {
                // If new photo is uploaded, delete old one and save the new one
                if (file_exists('./public/uploads/' . $data['client']['photo'])) {
                    unlink('./public/uploads/' . $data['client']['photo']);
                }

                // Create a final name for the new photo
                $final_name = 'julio-herrera-velutini.' . $ext;

                // Move the uploaded file to the destination folder
                if (move_uploaded_file($path_tmp, './public/uploads/' . $final_name)) {
                    // Update client data with the new photo
                    $form_data = array(
                        'name' => $_POST['name'],
                        'url' => $_POST['url'],
                        'photo' => $final_name,
                        'title' => $_POST['title'],
                        'image_alt' => $_POST['image_alt'],
                        'keywords' => $_POST['keywords'],
                        'seo_title' => $_POST['seo_title'],
                        'meta_description' => $_POST['meta_description'],
                        'domain_id' => $_POST['domain_id']
                    );
                    $this->Model_client->update($id, $form_data);
                    $success = 'Client is updated successfully';
                } else {
                    $valid = 0;
                    $error .= 'Failed to upload the image. Please try again.<br>';
                }
            }

            if ($valid) {
                $this->session->set_flashdata('success', $success);
                redirect(base_url() . 'admin/client');
            } else {
                $this->session->set_flashdata('error', $error);
                redirect(base_url() . 'admin/client/edit/' . $id);
            }
        } else {
            $this->session->set_flashdata('error', $error);
            redirect(base_url() . 'admin/client/edit/' . $id);
        }
    } else {
        $data['client'] = $this->Model_client->get_client($id);
        $this->load->view('admin/view_header', $data);
        $this->load->view('admin/view_client_edit', $data);
        $this->load->view('admin/view_footer');
    }
}



    // Delete client
    public function delete($id)
    {
        $tot = $this->Model_client->client_check($id);
        if (!$tot) {
            redirect(base_url() . 'admin/client');
            exit;
        }

        if (PROJECT_MODE == 0) {
            $this->session->set_flashdata('error', PROJECT_NOTIFICATION);
            redirect($_SERVER['HTTP_REFERER']);
        }

        $data['client'] = $this->Model_client->get_client($id);
        if ($data['client']) {
            unlink('./public/uploads/' . $data['client']['photo']);
        }

        $this->Model_client->delete($id);
        $success = 'Client is deleted successfully';
        $this->session->set_flashdata('success', $success);
        redirect(base_url() . 'admin/client');
    }
}