<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Domain extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('admin/Model_domain');  // Load Model_domain
        $this->load->model('admin/Model_common');  // Load Model_common
    }

    // List all domains
    public function index() {
        $data['setting'] = $this->Model_common->get_setting_data();  // Fetch settings using Model_common
        $data['domains'] = $this->Model_domain->get_all();  // Fetch all domains using Model_domain

        $this->load->view('admin/view_header', $data);
        $this->load->view('admin/view_domain_list', $data);
        $this->load->view('admin/view_footer');
    }

    // Add a new domain
    public function add() {
        $data['setting'] = $this->Model_common->get_setting_data();  // Fetch settings using Model_common
        
        if (isset($_POST['form1'])) {
            $this->form_validation->set_rules('domain_name', 'Domain Name', 'trim|required');

            if ($this->form_validation->run() == TRUE) {
                $form_data = array(
                    'domain_name' => $_POST['domain_name'],
                );
                $this->Model_domain->add($form_data);
                $this->session->set_flashdata('success', 'Domain is added successfully!');
                redirect(base_url() . 'admin/domain');
            } else {
                $this->session->set_flashdata('error', validation_errors());
            }
        }

        $this->load->view('admin/view_header', $data);
        $this->load->view('admin/view_domain_add', $data);
        $this->load->view('admin/view_footer');
    }

    // Edit a domain
    public function edit($id) {
        $data['setting'] = $this->Model_common->get_setting_data();  // Fetch settings using Model_common
        $data['domain'] = $this->Model_domain->get_domain($id);

        if (!$data['domain']) {
            redirect(base_url() . 'admin/domain');
            exit;
        }

        if (isset($_POST['form1'])) {
            $this->form_validation->set_rules('domain_name', 'Domain Name', 'trim|required');

            if ($this->form_validation->run() == TRUE) {
                $form_data = array(
                    'domain_name' => $_POST['domain_name'],
                );
                $this->Model_domain->update($id, $form_data);
                $this->session->set_flashdata('success', 'Domain is updated successfully!');
                redirect(base_url() . 'admin/domain');
            } else {
                $this->session->set_flashdata('error', validation_errors());
            }
        }

        $this->load->view('admin/view_header', $data);
        $this->load->view('admin/view_domain_edit', $data);
        $this->load->view('admin/view_footer');
    }

    // Delete a domain
    public function delete($id) {
        $domain = $this->Model_domain->get_domain($id);

        if ($domain) {
            $this->Model_domain->delete($id);
            $this->session->set_flashdata('success', 'Domain is deleted successfully!');
        } else {
            $this->session->set_flashdata('error', 'Domain not found.');
        }

        redirect(base_url() . 'admin/domain');
    }
}
