<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class News extends CI_Controller 
{
	function __construct() 
	{
        parent::__construct();
        $this->load->model('admin/Model_common');
        $this->load->model('admin/Model_news');
        $this->load->model('admin/Model_domain');
    }

	public function index()
	{
		$data['setting'] = $this->Model_common->get_setting_data();
		$data['news'] = $this->Model_news->show();

		$this->load->view('admin/view_header',$data);
		$this->load->view('admin/view_news',$data);
		$this->load->view('admin/view_footer');
	}

public function add() {
    $this->load->model('Model_domain');
    $this->load->model('Model_news');

    $data['setting'] = $this->Model_common->get_setting_data();
    $data['all_lang'] = $this->Model_common->all_lang();
    $data['all_domains'] = $this->Model_domain->get_all();
    $data['all_category'] = $this->Model_news->get_category();

    $error = '';
    $success = '';

    if(isset($_POST['form1'])) {

        if(PROJECT_MODE == 0) {
            $this->session->set_flashdata('error', PROJECT_NOTIFICATION);
            redirect($_SERVER['HTTP_REFERER']);
        }

        $valid = 1;

        // Form validation
       $this->form_validation->set_rules('news_title', 'News Title', 'trim|required');
        $this->form_validation->set_rules('news_content_short', 'News Short Content', 'trim|required');
        $this->form_validation->set_rules('news_content', 'News Content', 'trim|required');
        $this->form_validation->set_rules('category_id', 'Category', 'trim|required');
        $this->form_validation->set_rules('stitle', 'Short Title', 'trim|required');
        $this->form_validation->set_rules('title', 'Title', 'trim|required');
        $this->form_validation->set_rules('img_alt', 'Image Alt Text', 'trim|required');
        $this->form_validation->set_rules('domain_id', 'Domain ID', 'trim|required|integer');
        $this->form_validation->set_rules('news_date', 'News Date', 'trim|required');
        $this->form_validation->set_rules('comment', 'Comment', 'trim|required');
        $this->form_validation->set_rules('meta_title', 'Meta Title', 'trim|required');
        $this->form_validation->set_rules('meta_keyword', 'Meta Keyword', 'trim|required');
        $this->form_validation->set_rules('meta_description', 'Meta Description', 'trim|required');
        $this->form_validation->set_rules('encode_title', 'Encode Title', 'trim|required');  
        $this->form_validation->set_rules('lang_id', 'Language ID', 'trim|required|integer');   
        $this->form_validation->set_rules('type', 'News Type', 'trim|required');

        if($this->form_validation->run() == FALSE) {
            $valid = 0;
            $error .= validation_errors();
        }

        // Image validation
        $allowed_exts = ['webp', 'avif', 'png'];

        // Validate featured photo
        $path = $_FILES['photo']['name'];
        $path_tmp = $_FILES['photo']['tmp_name'];

        if($path != '') {
            $ext = pathinfo($path, PATHINFO_EXTENSION);
            if(!in_array(strtolower($ext), $allowed_exts)) {
                $valid = 0;
                $error .= 'Only WebP, AVIF, and PNG formats are allowed for the featured photo.<br>';
            }
        }

        // Validate banner image
        $path1 = $_FILES['banner']['name'];
        $path_tmp1 = $_FILES['banner']['tmp_name'];

        if($path1 != '') {
            $ext1 = pathinfo($path1, PATHINFO_EXTENSION);
            if(!in_array(strtolower($ext1), $allowed_exts)) {
                $valid = 0;
                $error .= 'Only WebP, AVIF, and PNG formats are allowed for the banner image.<br>';
            }
        }

        if($valid == 1) {
            // Prepare data
            $form_data = array(
                'news_title'         => $_POST['news_title'],
                'news_content'       => $_POST['news_content'],
                'news_content_short' => $_POST['news_content_short'],
                'news_date'          => $_POST['news_date'],
                'category_id'        => $_POST['category_id'],
                'comment'            => $_POST['comment'],
                'meta_title'         => $_POST['meta_title'],
                'meta_keyword'       => $_POST['meta_keyword'],
                'meta_description'   => $_POST['meta_description'],
                'lang_id'            => $_POST['lang_id'],
                'stitle'             => $_POST['stitle'],
                'title'              => $_POST['title'],
                'img_alt'            => $_POST['img_alt'],
                'domain_id'          => $_POST['domain_id'],
                'encode_title'       => $_POST['encode_title'],
                'type'               => $_POST['type']
            );

            // Upload featured photo
            if($path != '') {
                $final_name = 'news-' . time() . '.' . $ext;
                move_uploaded_file($path_tmp, './public/uploads/' . $final_name);
                $form_data['photo'] = $final_name;
            }

            // Upload banner image
            if($path1 != '') {
                $final_name1 = 'news-banner-' . time() . '.' . $ext1;
                move_uploaded_file($path_tmp1, './public/uploads/' . $final_name1);
                $form_data['banner'] = $final_name1;
            }

            // Insert data into database
            $this->Model_news->add($form_data);

            $this->session->set_flashdata('success', 'News added successfully');
            redirect(base_url().'admin/news');
        } else {
            $this->session->set_flashdata('error', $error);
            redirect(base_url().'admin/news/add');
        }
    } else {
        $this->load->view('admin/view_header', $data);
        $this->load->view('admin/view_news_add', $data);
        $this->load->view('admin/view_footer');
    }
}





public function edit($id) {
    $tot = $this->Model_news->news_check($id);
    if(!$tot) {
        redirect(base_url().'admin/news');
        exit;
    }

    $data['setting'] = $this->Model_common->get_setting_data();
    $data['all_lang'] = $this->Model_common->all_lang();
    $this->load->model('Model_domain');
    $this->load->model('Model_news');

    $data['all_domains'] = $this->Model_domain->get_all();
    $data['all_category'] = $this->Model_news->get_category();
    $data['news'] = $this->Model_news->getData($id);

    $error = '';
    $success = '';

    if(isset($_POST['form1'])) {

        if(PROJECT_MODE == 0) {
            $this->session->set_flashdata('error', PROJECT_NOTIFICATION);
            redirect($_SERVER['HTTP_REFERER']);
        }

        $valid = 1;

        // Form validation
        $this->form_validation->set_rules('news_title', 'News Title', 'trim|required');
        $this->form_validation->set_rules('news_content_short', 'News Short Content', 'trim|required');
        $this->form_validation->set_rules('news_content', 'News Content', 'trim|required');
        $this->form_validation->set_rules('category_id', 'Category', 'trim|required');
        $this->form_validation->set_rules('stitle', 'Short Title', 'trim|required');
        $this->form_validation->set_rules('title', 'Title', 'trim|required');
        $this->form_validation->set_rules('img_alt', 'Image Alt Text', 'trim|required');
        $this->form_validation->set_rules('domain_id', 'Domain ID', 'trim|required|integer');
        $this->form_validation->set_rules('news_date', 'News Date', 'trim|required');
        $this->form_validation->set_rules('comment', 'Comment', 'trim|required');
        $this->form_validation->set_rules('meta_title', 'Meta Title', 'trim|required');
        $this->form_validation->set_rules('meta_keyword', 'Meta Keyword', 'trim|required');
        $this->form_validation->set_rules('meta_description', 'Meta Description', 'trim|required');
        $this->form_validation->set_rules('encode_title', 'Encode Title', 'trim|required');  
        $this->form_validation->set_rules('lang_id', 'Language ID', 'trim|required|integer');   
        $this->form_validation->set_rules('type', 'Type', 'trim|required');
        
        if($this->form_validation->run() == FALSE) {
            $valid = 0;
            $error .= validation_errors();
        }

        // Image validation
        $allowed_exts = ['webp', 'avif', 'png'];

        // Validate featured photo
        $path = $_FILES['photo']['name'];
        $path_tmp = $_FILES['photo']['tmp_name'];

        if($path != '') {
            $ext = pathinfo($path, PATHINFO_EXTENSION);
            if(!in_array(strtolower($ext), $allowed_exts)) {
                $valid = 0;
                $error .= 'Only WebP, AVIF, and PNG formats are allowed for the featured photo.<br>';
            }
        }

        // Validate banner image
        $path1 = $_FILES['banner']['name'];
        $path_tmp1 = $_FILES['banner']['tmp_name'];

        if($path1 != '') {
            $ext1 = pathinfo($path1, PATHINFO_EXTENSION);
            if(!in_array(strtolower($ext1), $allowed_exts)) {
                $valid = 0;
                $error .= 'Only WebP, AVIF, and PNG formats are allowed for the banner image.<br>';
            }
        }

        if($valid == 1) {
            // Prepare data
            $form_data = array(
                'news_title'         => $_POST['news_title'],
                'news_content'       => $_POST['news_content'],
                'news_content_short' => $_POST['news_content_short'],
                'news_date'          => $_POST['news_date'],
                'category_id'        => $_POST['category_id'],
                'comment'            => $_POST['comment'],
                'meta_title'         => $_POST['meta_title'],
                'meta_keyword'       => $_POST['meta_keyword'],
                'meta_description'   => $_POST['meta_description'],
                'lang_id'            => $_POST['lang_id'],
                'stitle'             => $_POST['stitle'],
                'title'              => $_POST['title'],
                'img_alt'            => $_POST['img_alt'],
                'domain_id'          => $_POST['domain_id'],
                'encode_title'       => $_POST['encode_title'],
                'type'               => $_POST['type']
            );

            // Upload featured photo
            if($path != '') {
                unlink('./public/uploads/'.$data['news']['photo']);
                $final_name = 'news-'.$id.'.'.$ext;
                move_uploaded_file($path_tmp, './public/uploads/'.$final_name);
                $form_data['photo'] = $final_name;
            }

            // Upload banner image
            if($path1 != '') {
                unlink('./public/uploads/'.$data['news']['banner']);
                $final_name1 = 'news-banner-'.$id.'.'.$ext1;
                move_uploaded_file($path_tmp1, './public/uploads/'.$final_name1);
                $form_data['banner'] = $final_name1;
            }

            // Update news in database
            $this->Model_news->update($id, $form_data);

            $this->session->set_flashdata('success', 'News updated successfully');
            redirect(base_url().'admin/news');
        } else {
            $this->session->set_flashdata('error', $error);
            redirect(base_url().'admin/news/edit/'.$id);
        }
    } else {
        $this->load->view('admin/view_header', $data);
        $this->load->view('admin/view_news_edit', $data);
        $this->load->view('admin/view_footer');
    }
}





	public function delete($id) 
	{
    	$tot = $this->Model_news->news_check($id);
    	if(!$tot) {
    		redirect(base_url().'admin/news');
        	exit;
    	}

		if(PROJECT_MODE == 0) {
			$this->session->set_flashdata('error',PROJECT_NOTIFICATION);
			redirect($_SERVER['HTTP_REFERER']);
		}

        $data['news'] = $this->Model_news->getData($id);
        if($data['news']) {
            unlink('./public/uploads/'.$data['news']['photo']);
            unlink('./public/uploads/'.$data['news']['banner']);
        }

        $this->Model_news->delete($id);
        $success = 'News is deleted successfully';
		$this->session->set_flashdata('success',$success);
		redirect(base_url().'admin/news');
    }

 
}