<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Pricing_table extends CI_Controller 
{
   function __construct() 
    {
        parent::__construct();
        $this->load->model('admin/Model_common');
        $this->load->model('admin/Model_pricing_table'); 
        $this->load->model('admin/Model_domain');
        $this->load->model('admin/Model_news');
    }

    public function index()
    {
        $data['setting'] = $this->Model_common->get_setting_data();
        $data['pricing_table'] = $this->Model_pricing_table->show(); // This should pass the correct data

        // Fetch categories and domains for dropdowns
        $data['all_categories'] = $this->Model_news->get_category();
        $data['all_domains'] = $this->Model_domain->get_all();

        $this->load->view('admin/view_header', $data);
        $this->load->view('admin/view_pricing_table', $data);
        $this->load->view('admin/view_footer');
    }

public function add()
{
    $data['setting'] = $this->Model_common->get_setting_data();
    $data['all_lang'] = $this->Model_common->all_lang();
    $data['all_categories'] = $this->Model_news->get_category();
    $data['all_domains'] = $this->Model_domain->get_all();

    $error = '';
    $success = '';

    if (isset($_POST['form1'])) {
        if (PROJECT_MODE == 0) {
            $this->session->set_flashdata('error', PROJECT_NOTIFICATION);
            redirect($_SERVER['HTTP_REFERER']);
        }

        $valid = 1;

        // Form validation
        $this->form_validation->set_rules('news_title', 'News Title', 'trim|required');
        $this->form_validation->set_rules('news_content', 'News Content', 'trim|required');
        $this->form_validation->set_rules('news_content_short', 'Short News Content', 'trim|required');
        $this->form_validation->set_rules('category_id', 'Category ID', 'trim|required');
        $this->form_validation->set_rules('meta_title', 'Meta Title', 'trim|required');
        $this->form_validation->set_rules('meta_keyword', 'Meta Keyword', 'trim|required');
        $this->form_validation->set_rules('meta_description', 'Meta Description', 'trim|required');
        $this->form_validation->set_rules('stitle', 'Subtitle', 'trim|required');
        $this->form_validation->set_rules('title', 'Title', 'trim|required');
        $this->form_validation->set_rules('img_alt', 'Image Alt', 'trim|required');
        $this->form_validation->set_rules('domain_id', 'Domain ID', 'trim|required');
        $this->form_validation->set_rules('encode_title', 'Encode Title', 'trim|required');
        $this->form_validation->set_rules('photo', 'Photo', 'trim|required');

        if ($this->form_validation->run() == FALSE) {
            $valid = 0;
            $error .= validation_errors();
        }

        // Handle file upload for photo
        $photo_url = '';  // Default value in case no file is uploaded
        if (isset($_FILES['photo']) && $_FILES['photo']['error'] == 0) {
            $path = $_FILES['photo']['name'];
            $path_tmp = $_FILES['photo']['tmp_name'];

            if ($path != '') {
                // Validate file extension
                $ext = pathinfo($path, PATHINFO_EXTENSION);
                $file_name = basename($path, '.' . $ext);
                $ext_check = $this->Model_common->extension_check_photo($ext);
                if ($ext_check == FALSE) {
                    $valid = 0;
                    $error .= 'You must upload a jpg, jpeg, gif, or png file for the featured photo.<br>';
                } else {
                    // Ensure the upload directory exists
                    $upload_path = './public/uploads/';
                    if (!is_dir($upload_path)) {
                        mkdir($upload_path, 0777, true); // Create directory if not exists
                    }

                    // Generate a unique file name using the current timestamp
                    $new_file_name = time() . '-' . $file_name . '.' . $ext;

                    // Move the uploaded file to the designated directory
                    if (move_uploaded_file($path_tmp, $upload_path . $new_file_name)) {
                        $photo_url = $new_file_name;  // Store only the file name in the database
                    } else {
                        $valid = 0;
                        $error .= 'Failed to upload the photo. Please try again.<br>';
                    }
                }
            }
        }

        // Handle file upload for another image (image_url)
        $image_url = '';  // Default value in case no file is uploaded
        if (isset($_FILES['image']) && $_FILES['image']['error'] == 0) {
            $image_path = $_FILES['image']['name'];
            $image_tmp = $_FILES['image']['tmp_name'];

            if ($image_path != '') {
                // Validate file extension
                $image_ext = pathinfo($image_path, PATHINFO_EXTENSION);
                $image_file_name = basename($image_path, '.' . $image_ext);
                $image_ext_check = $this->Model_common->extension_check_photo($image_ext);
                if ($image_ext_check == FALSE) {
                    $valid = 0;
                    $error .= 'You must upload a jpg, jpeg, gif, or png file for the additional image.<br>';
                } else {
                    // Ensure the upload directory exists
                    $image_upload_path = './public/uploads/';
                    if (!is_dir($image_upload_path)) {
                        mkdir($image_upload_path, 0777, true); // Create directory if not exists
                    }

                    // Generate a unique file name using the current timestamp
                    $new_image_file_name = time() . '-' . $image_file_name . '.' . $image_ext;

                    // Move the uploaded file to the designated directory
                    if (move_uploaded_file($image_tmp, $image_upload_path . $new_image_file_name)) {
                        $image_url = $new_image_file_name;  // Store only the file name in the database
                    } else {
                        $valid = 0;
                        $error .= 'Failed to upload the additional image. Please try again.<br>';
                    }
                }
            }
        }

        if ($valid == 1) {
            // Prepare data to insert
            $form_data = array(
                'news_title'       => $_POST['news_title'],
                'news_content'     => $_POST['news_content'],
                'news_content_short'=> $_POST['news_content_short'],
                'photo'            => $photo_url,  // Store only file name
                'image'            => $image_url,  // Store additional image file name
                'category_id'      => $_POST['category_id'],
                'meta_title'       => $_POST['meta_title'],
                'meta_keyword'     => $_POST['meta_keyword'],
                'meta_description' => $_POST['meta_description'],
                'stitle'           => $_POST['stitle'],
                'title'            => $_POST['title'],
                'img_alt'          => $_POST['img_alt'],
                'domain_id'        => $_POST['domain_id'],
                'encode_title'     => $_POST['encode_title'],
            );

            // Call the model to insert the data
            $this->Model_pricing_table->add($form_data);

            // Success message
            $success = 'Trending table item is added successfully!';
            $this->session->set_flashdata('success', $success);
            redirect(base_url() . 'admin/pricing_table');
        } else {
            $this->session->set_flashdata('error', $error);
            redirect(base_url() . 'admin/pricing_table/add');
        }
    } else {
        // Load view files
        $this->load->view('admin/view_header', $data);
        $this->load->view('admin/view_pricing_table_add', $data);
        $this->load->view('admin/view_footer');
    }
}







public function edit($id)
{
    // If there is no pricing table in this id, then redirect
    $tot = $this->Model_pricing_table->trending_table_check($id);
    if (!$tot) {
        redirect(base_url().'admin/pricing_table');
        exit;
    }

    // Data to be passed to the view
    $data['setting'] = $this->Model_common->get_setting_data();
    $data['all_lang'] = $this->Model_common->all_lang();
    $data['all_categories'] = $this->Model_news->get_category();
    $data['all_domains'] = $this->Model_domain->get_all();

    $error = '';
    $success = '';

    // Handle form submission
    if (isset($_POST['form1'])) {
        // Prevent processing if the project is in demo mode
        if (PROJECT_MODE == 0) {
            $this->session->set_flashdata('error', PROJECT_NOTIFICATION);
            redirect($_SERVER['HTTP_REFERER']);
            return;
        }

        $valid = 1;

        // Form validation rules
        $this->form_validation->set_rules('news_title', 'News Title', 'trim|required');
        $this->form_validation->set_rules('news_content', 'News Content', 'trim|required');
        $this->form_validation->set_rules('news_content_short', 'Short News Content', 'trim|required');
        $this->form_validation->set_rules('category_id', 'Category ID', 'trim|required');
        $this->form_validation->set_rules('meta_title', 'Meta Title', 'trim|required');
        $this->form_validation->set_rules('meta_keyword', 'Meta Keyword', 'trim|required');
        $this->form_validation->set_rules('meta_description', 'Meta Description', 'trim|required');
        $this->form_validation->set_rules('stitle', 'Subtitle', 'trim|required');
        $this->form_validation->set_rules('title', 'Title', 'trim|required');
        $this->form_validation->set_rules('img_alt', 'Image Alt', 'trim|required');
        $this->form_validation->set_rules('domain_id', 'Domain ID', 'trim|required');
        $this->form_validation->set_rules('encode_title', 'Encode Title', 'trim|required');

        if ($this->form_validation->run() == FALSE) {
            $valid = 0;
            $error .= validation_errors();
        }

        // Handle file upload for photo
        $photo_url = '';  // Default to empty if no new photo is uploaded
        if (isset($_FILES['photo']) && $_FILES['photo']['error'] == 0) {
            $path = $_FILES['photo']['name'];
            $path_tmp = $_FILES['photo']['tmp_name'];

            if ($path != '') {
                // Validate file extension
                $ext = pathinfo($path, PATHINFO_EXTENSION);
                $file_name = basename($path, '.' . $ext);
                $ext_check = $this->Model_common->extension_check_photo($ext);
                if ($ext_check == FALSE) {
                    $valid = 0;
                    $error .= 'You must upload a jpg, jpeg, gif, or png file for the featured photo.<br>';
                } else {
                    // Ensure the upload directory exists
                    $upload_path = './public/uploads/';
                    if (!is_dir($upload_path)) {
                        mkdir($upload_path, 0777, true); // Create directory if not exists
                    }

                    // Generate a unique file name using the current timestamp
                    $new_file_name = time() . '-' . $file_name . '.' . $ext;

                    // Move the uploaded file to the designated directory
                    if (move_uploaded_file($path_tmp, $upload_path . $new_file_name)) {
                        $photo_url = $new_file_name;
                    } else {
                        $valid = 0;
                        $error .= 'Failed to upload the photo. Please try again.<br>';
                    }
                }
            }
        }

        // If the form is valid, update the data in the database
        if ($valid == 1) {
            // Prepare data for updating
            $form_data = array(
                'news_title'       => $_POST['news_title'],
                'news_content'     => $_POST['news_content'],
                'news_content_short'=> $_POST['news_content_short'],
                'category_id'      => $_POST['category_id'],
                'meta_title'       => $_POST['meta_title'],
                'meta_keyword'     => $_POST['meta_keyword'],
                'meta_description' => $_POST['meta_description'],
                'stitle'           => $_POST['stitle'],
                'title'            => $_POST['title'],
                'img_alt'          => $_POST['img_alt'],
                'domain_id'        => $_POST['domain_id'],
                'encode_title'     => $_POST['encode_title'],
            );

            // If a new photo is uploaded, update the photo column
            if ($photo_url != '') {
                $form_data['photo'] = $photo_url;
            } else {
                // Retain the existing photo if not uploading a new one
                $existing_data = $this->Model_pricing_table->getData($id);
                $form_data['photo'] = $existing_data['photo'];
            }

            // Call the model to update the data
            $this->Model_pricing_table->update($id, $form_data);

            // Success message
            $success = 'Trending table is updated successfully';
            $this->session->set_flashdata('success', $success);
            redirect(base_url() . 'admin/pricing_table');
        } else {
            $this->session->set_flashdata('error', $error);
            redirect(base_url() . 'admin/pricing_table/edit/' . $id);
        }
    } else {
        // Load the current record data
        $data['trending_table'] = $this->Model_pricing_table->getData($id);

        // Load the view files
        $this->load->view('admin/view_header', $data);
        $this->load->view('admin/view_pricing_table_edit', $data);
        $this->load->view('admin/view_footer');
    }
}



   public function delete($id)
{
    // Check if there is a trending table with the given ID
    $tot = $this->Model_pricing_table->trending_table_check($id);
    if (!$tot) {
        redirect(base_url() . 'admin/pricing_table');
        exit;
    }

    // Check if the project is in demo mode
    if (PROJECT_MODE == 0) {
        $this->session->set_flashdata('error', PROJECT_NOTIFICATION);
        redirect($_SERVER['HTTP_REFERER']);
    }

    // Get the existing photo file name (if any)
    $existing_data = $this->Model_pricing_table->getData($id);
    $photo_url = $existing_data['photo'];

    // If there is a photo, delete the file from the server
    if ($photo_url != '') {
        $file_path = './public/uploads/' . $photo_url;

        if (file_exists($file_path)) {
            unlink($file_path);  // Delete the photo file from the server
        }
    }

    // Delete the record from the database
    $this->Model_pricing_table->delete($id);

    // Set success message
    $success = 'Trending table is deleted successfully';
    $this->session->set_flashdata('success', $success);

    // Redirect back to the pricing table page
    redirect(base_url() . 'admin/pricing_table');
}

}
?>
