<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Model_domain extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    // Get all domains
    public function get_all() {
        return $this->db->get('tbl_domain')->result_array();
    }

    // Get a single domain by ID
    public function get_domain($id) {
        return $this->db->get_where('tbl_domain', ['domain_id' => $id])->row_array();
    }

    // Add a domain
    public function add($data) {
        return $this->db->insert('tbl_domain', $data);
    }

    // Update a domain
    public function update($id, $data) {
        $this->db->where('domain_id', $id);
        return $this->db->update('tbl_domain', $data);
    }

    // Delete a domain
    public function delete($id) {
        return $this->db->delete('tbl_domain', ['domain_id' => $id]);
    }
}