<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Model_common extends CI_Model 
{
    function all_lang()
    {
        $sql = "SELECT * FROM tbl_lang";
        $query = $this->db->query($sql);
        return $query->result_array();
    }

    // Get setting data where ID is 1
    public function get_setting_data()
    {
        $query = $this->db->get_where('tbl_settings', ['id' => 1]);
        return $query->row_array();
    }
    
    // Validate photo extensions (jpg, png, jpeg, gif)
    public function extension_check_photo($ext) {
        $ext = strtolower($ext);  // Convert to lowercase
        $valid_extensions = ['jpg', 'png', 'jpeg', 'gif'];
        return in_array($ext, $valid_extensions);
    }

    // Validate file extensions (photo formats + pdf, doc, xls, csv)
    public function extension_check_file($ext) {
        $ext = strtolower($ext);  // Convert to lowercase
        $valid_extensions = ['jpg', 'png', 'jpeg', 'gif', 'pdf', 'doc', 'docx', 'xls', 'xlsx', 'csv'];
        return in_array($ext, $valid_extensions);
    }

    // Image resizing function (thumbnail creation)
    public function image_handler($source_image, $destination, $tn_w = 100, $tn_h = 100, $quality = 80) {
        $info = getimagesize($source_image);
        if (!$info) {
            return false;
        }

        $imgtype = image_type_to_mime_type($info[2]);

        switch ($imgtype) {
            case 'image/jpeg':
                $source = imagecreatefromjpeg($source_image);
                break;
            case 'image/gif':
                $source = imagecreatefromgif($source_image);
                break;
            case 'image/png':
                $source = imagecreatefrompng($source_image);
                break;
            default:
                return false;
        }

        $src_w = imagesx($source);
        $src_h = imagesy($source);
        $src_ratio = $src_w / $src_h;

        if ($tn_w / $tn_h > $src_ratio) {
            $new_h = $tn_w / $src_ratio;
            $new_w = $tn_w;
        } else {
            $new_w = $tn_h * $src_ratio;
            $new_h = $tn_h;
        }

        $x_mid = $new_w / 2;
        $y_mid = $new_h / 2;

        $newpic = imagecreatetruecolor(round($new_w), round($new_h));
        imagecopyresampled($newpic, $source, 0, 0, 0, 0, $new_w, $new_h, $src_w, $src_h);
        
        $final = imagecreatetruecolor($tn_w, $tn_h);
        imagecopyresampled($final, $newpic, 0, 0, ($x_mid - ($tn_w / 2)), ($y_mid - ($tn_h / 2)), $tn_w, $tn_h, $tn_w, $tn_h);

        return imagejpeg($final, $destination, $quality);
    }

    // Get all domains from the database
    public function get_all_domains()
    {
        $query = $this->db->query("SELECT * FROM tbl_domains ORDER BY domain_name ASC");
        return $query->result_array();
    }
}
