<?php
class Model_news extends CI_Model {

    function get_auto_increment_id() {
        $sql = "SHOW TABLE STATUS LIKE 'tbl_news'";
        $query = $this->db->query($sql);
        return $query->result_array();
    }

    function show() {
        $sql = "SELECT
                t1.news_id,
                t1.news_title,
                t1.news_content,
                t1.news_content_short,
                t1.news_date,
                t1.photo,
                t1.banner,
                t1.category_id,
                t1.comment,
                t1.meta_title,
                t1.meta_keyword,
                t1.meta_description,
                t1.lang_id,
                t1.stitle,
                t1.title,
                t1.img_alt,
                t1.domain_id,
                t1.encode_title,
                t1.type,  -- Added type field
                t2.category_name,
                t3.lang_name
                FROM tbl_news t1
                JOIN tbl_category t2
                ON t1.category_id = t2.category_id
                JOIN tbl_lang t3
                ON t1.lang_id = t3.lang_id
                ORDER BY t1.news_id DESC";
        $query = $this->db->query($sql);
        return $query->result_array();
    }

    function add($data) {
        $this->db->insert('tbl_news', $data);
        return $this->db->insert_id();
    }

    function update($id, $data) {
        $this->db->where('news_id', $id);
        $this->db->update('tbl_news', $data);
    }

    function delete($id) {
        $this->db->where('news_id', $id);
        $this->db->delete('tbl_news');
    }

    function getData($id) {
        $sql = 'SELECT *, type FROM tbl_news WHERE news_id=?';   
        $query = $this->db->query($sql, array($id));
        return $query->first_row('array');
    }

    function get_category() {
        $sql = 'SELECT * FROM tbl_category ORDER BY category_name ASC';
        $query = $this->db->query($sql);
        return $query->result_array();
    }

    function news_check($id) {
        $sql = 'SELECT *, type FROM tbl_news WHERE news_id=?'; 
        $query = $this->db->query($sql, array($id));
        return $query->first_row('array');
    }

    public function get_news_by_id($news_id) {
        return $this->db->get_where('tbl_news', ['news_id' => $news_id])->row_array();
    }

    public function update_news($news_id, $data) {
        $this->db->where('news_id', $news_id);
        return $this->db->update('tbl_news', $data);
    }

    public function get_all_languages() {
        return $this->db->get('tbl_languages')->result_array();
    }
}
