<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Model_pricing_table extends CI_Model {

    // Fetch the auto-increment ID of the table
    function get_auto_increment_id() {
        $sql = "SHOW TABLE STATUS LIKE 'tbl_trending_table'";
        $query = $this->db->query($sql);
        return $query->row_array();  // Return first row instead of result array
    }
    
    // Fetch all pricing table data
    function show() {
        // Use Active Record for querying
        $query = $this->db->get('tbl_trending_table');
        return $query->result_array();  // Return result as an array
    }

    // Insert new record into the pricing table
    function add($data) {
        $this->db->insert('tbl_trending_table', $data);
        return $this->db->insert_id();  // Return the last inserted ID
    }

    // Update an existing record
    function update($id, $data) {
        $this->db->where('news_id', $id);
        $this->db->update('tbl_trending_table', $data);
    }

    // Delete a record
    function delete($id) {
        $this->db->where('news_id', $id);
        $this->db->delete('tbl_trending_table');
    }

    // Get a single record by ID
    function getData($id) {
        $query = $this->db->get_where('tbl_trending_table', array('news_id' => $id));
        return $query->row_array();  // Return the first matching row as an array
    }

    // Check if a specific pricing table record exists
    function trending_table_check($id) {
        $query = $this->db->get_where('tbl_trending_table', array('news_id' => $id));
        return $query->row_array();  // Return the first matching row as an array
    }
}
