<?php
if(!$this->session->userdata('id')) {
    redirect(base_url().'admin');
}
?>
<section class="content-header">
    <div class="content-header-left">
        <h1>Add Client</h1>
    </div>
    <div class="content-header-right">
        <a href="<?php echo base_url(); ?>admin/client" class="btn btn-primary btn-sm">View All</a>
    </div>
</section>

<section class="content">
    <div class="row">
        <div class="col-md-12">
            <?php
            if($this->session->flashdata('error')) {
                ?>
                <div class="callout callout-danger">
                    <p><?php echo $this->session->flashdata('error'); ?></p>
                </div>
                <?php
            }
            if($this->session->flashdata('success')) {
                ?>
                <div class="callout callout-success">
                    <p><?php echo $this->session->flashdata('success'); ?></p>
                </div>
                <?php
            }
            ?>

            <?php echo form_open_multipart(base_url().'admin/client/add', array('class' => 'form-horizontal')); ?>
            <div class="box box-info">
                <div class="box-body">
                    <!-- Name Field -->
                    <div class="form-group">
                        <label class="col-sm-2 control-label">Name <span>*</span></label>
                        <div class="col-sm-6">
                            <input type="text" autocomplete="off" class="form-control" name="name" value="<?php echo set_value('name'); ?>">
                        </div>
                    </div>

                    <!-- URL Field -->
                    <div class="form-group">
                        <label class="col-sm-2 control-label">URL</label>
                        <div class="col-sm-6">
                            <input type="text" autocomplete="off" class="form-control" name="url" value="<?php echo set_value('url'); ?>">
                        </div>
                    </div>

                    <!-- Photo Field -->
                    <div class="form-group">
                        <label class="col-sm-2 control-label">Photo <span>*</span></label>
                        <div class="col-sm-6" style="padding-top:5px">
                            <input type="file" name="photo" accept=".webp,.avif">(Only WebP or AVIF files allowed)
                        </div>
                    </div>

                    <!-- SEO Title Field -->
                    <div class="form-group">
                        <label class="col-sm-2 control-label">SEO Title</label>
                        <div class="col-sm-6">
                            <input type="text" autocomplete="off" class="form-control" name="title" value="<?php echo set_value('title'); ?>">
                        </div>
                    </div>

                    <!-- Image Alt Text Field -->
                    <div class="form-group">
                        <label class="col-sm-2 control-label">Image Alt Text</label>
                        <div class="col-sm-6">
                            <input type="text" autocomplete="off" class="form-control" name="image_alt" value="<?php echo set_value('image_alt'); ?>">
                        </div>
                    </div>

                    <!-- Keywords Field -->
                    <div class="form-group">
                        <label class="col-sm-2 control-label">Keywords</label>
                        <div class="col-sm-6">
                            <input type="text" autocomplete="off" class="form-control" name="keywords" value="<?php echo set_value('keywords'); ?>">
                        </div>
                    </div>

                    <!-- SEO Title (For Meta) Field -->
                    <div class="form-group">
                        <label class="col-sm-2 control-label">SEO Title (For Meta)</label>
                        <div class="col-sm-6">
                            <input type="text" autocomplete="off" class="form-control" name="seo_title" value="<?php echo set_value('seo_title'); ?>">
                        </div>
                    </div>

                    <!-- Meta Description Field -->
                    <div class="form-group">
                        <label class="col-sm-2 control-label">Meta Description</label>
                        <div class="col-sm-6">
                            <textarea class="form-control" name="meta_description"><?php echo set_value('meta_description'); ?></textarea>
                        </div>
                    </div>

                    <!-- Domain Selection -->
                    <div class="form-group">
                        <label class="col-sm-2 control-label">Select Domain</label>
                        <div class="col-sm-6">
                            <select name="domain_id" class="form-control">
                                <?php foreach ($domains as $domain): ?>
                                    <option value="<?= $domain['domain_id']; ?>" <?php echo set_select('domain_id', $domain['domain_id']); ?>>
                                        <?= $domain['domain_name']; ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>

                    <!-- Submit Button -->
                    <div class="form-group">
                        <label class="col-sm-2 control-label"></label>
                        <div class="col-sm-6">
                            <button type="submit" class="btn btn-success pull-left" name="form1">Submit</button>
                        </div>
                    </div>

                </div>
            </div>
            <?php echo form_close(); ?>
        </div>
    </div>
</section>
