<?php
if(!$this->session->userdata('id')) {
    redirect(base_url().'admin');
}
?>
<section class="content-header">
	<div class="content-header-left">
		<h1>Edit Client</h1>
	</div>
	<div class="content-header-right">
		<a href="<?php echo base_url(); ?>admin/client" class="btn btn-primary btn-sm">View All</a>
	</div>
</section>

<section class="content">

	<div class="row">
		<div class="col-md-12">

			<?php
			if($this->session->flashdata('error')) {
				?>
				<div class="callout callout-danger">
					<p><?php echo $this->session->flashdata('error'); ?></p>
				</div>
				<?php
			}
			if($this->session->flashdata('success')) {
				?>
				<div class="callout callout-success">
					<p><?php echo $this->session->flashdata('success'); ?></p>
				</div>
				<?php
			}
			?>

			<?php echo form_open_multipart(base_url().'admin/client/edit/'.$client['id'], array('class' => 'form-horizontal')); ?>
				<div class="box box-info">
					<div class="box-body">
						<div class="form-group">
							<label for="" class="col-sm-2 control-label">Name <span>*</span></label>
							<div class="col-sm-6">
								<input type="text" autocomplete="off" class="form-control" name="name" value="<?php echo $client['name']; ?>">
							</div>
						</div>

						<div class="form-group">
							<label for="" class="col-sm-2 control-label">URL</label>
							<div class="col-sm-6">
								<input type="text" autocomplete="off" class="form-control" name="url" value="<?php echo $client['url']; ?>">
							</div>
						</div>

						<div class="form-group">
							<label for="" class="col-sm-2 control-label">Existing Photo</label>
							<div class="col-sm-9" style="padding-top:5px">
								<img src="<?php echo base_url(); ?>public/uploads/<?php echo $client['photo']; ?>" alt="Client Photo" style="width:180px;">
							</div>
						</div>

						<div class="form-group">
							<label for="" class="col-sm-2 control-label">Photo</label>
							<div class="col-sm-6" style="padding-top:5px">
								<input type="file" name="photo">(Only WebP or AVIF files allowed)
							</div>
						</div>

						<!-- Add more fields here -->
						<div class="form-group">
							<label for="" class="col-sm-2 control-label">SEO Title</label>
							<div class="col-sm-6">
								<input type="text" autocomplete="off" class="form-control" name="title" value="<?php echo $client['title']; ?>">
							</div>
						</div>

						<div class="form-group">
							<label for="" class="col-sm-2 control-label">Image Alt Text</label>
							<div class="col-sm-6">
								<input type="text" autocomplete="off" class="form-control" name="image_alt" value="<?php echo $client['image_alt']; ?>">
							</div>
						</div>

						<div class="form-group">
							<label for="" class="col-sm-2 control-label">Keywords</label>
							<div class="col-sm-6">
								<input type="text" autocomplete="off" class="form-control" name="keywords" value="<?php echo $client['keywords']; ?>">
							</div>
						</div>

						<div class="form-group">
							<label for="" class="col-sm-2 control-label">SEO Title (For Meta)</label>
							<div class="col-sm-6">
								<input type="text" autocomplete="off" class="form-control" name="seo_title" value="<?php echo $client['seo_title']; ?>">
							</div>
						</div>

						<div class="form-group">
							<label for="" class="col-sm-2 control-label">Meta Description</label>
							<div class="col-sm-6">
								<textarea class="form-control" name="meta_description"><?php echo $client['meta_description']; ?></textarea>
							</div>
						</div>

						<div class="form-group">
							<label for="" class="col-sm-2 control-label">Select Domain</label>
							<div class="col-sm-6">
								<select name="domain_id" class="form-control">
									<?php foreach ($domains as $domain): ?>
										<option value="<?= $domain['domain_id']; ?>" <?php echo ($domain['domain_id'] == $client['domain_id']) ? 'selected' : ''; ?>>
											<?= $domain['domain_name']; ?>
										</option>
									<?php endforeach; ?>
								</select>
							</div>
						</div>

						<div class="form-group">
							<label for="" class="col-sm-2 control-label"></label>
							<div class="col-sm-6">
								<button type="submit" class="btn btn-success pull-left" name="form1">Submit</button>
							</div>
						</div>

					</div>
				</div>
			<?php echo form_close(); ?>
		</div>
	</div>

</section>