<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Domain Management</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
            background-color: #f8f9fa;
        }

        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            background-color: #fff;
            border-radius: 8px;
            overflow: hidden;
        }

        .table th, .table td {
            border: 1px solid #ddd;
            padding: 12px 15px;
            text-align: left;
        }

        .table th {
            background-color: #f4f4f4;
            color: #333;
        }

        .table tr:nth-child(even) {
            background-color: #f9f9f9;
        }

        .table tr:hover {
            background-color: #f1f1f1;
        }

        .table td a {
            text-decoration: none;
            color: #007BFF;
            margin-right: 10px;
            padding: 5px 10px;
            border-radius: 4px;
            font-size: 14px;
        }

        .table td a:hover {
            background-color: #f1f1f1;
            text-decoration: underline;
        }

        .table td a.edit {
            background-color: #007bff;
            color: white;
        }

        .table td a.edit:hover {
            background-color: #0056b3;
        }

        .table td a.delete {
            background-color: #dc3545;
            color: white;
        }

        .table td a.delete:hover {
            background-color: #b52d3a;
        }

        a.add-new {
            display: inline-block;
            background-color: #28a745;
            color: white;
            padding: 12px 20px;
            border-radius: 5px;
            font-size: 14px;
            text-decoration: none;
        }

        a.add-new:hover {
            background-color: #218838;
        }

        @media (max-width: 768px) {
            body {
                margin: 10px;
            }

            .table th, .table td {
                font-size: 14px;
                padding: 8px 10px;
            }

            a.add-new {
                width: 100%;
                text-align: center;
                font-size: 16px;
            }
        }
    </style>
</head>
<body>

<div class="header">
    <h2>Domain Management</h2>
    <a href="<?= base_url('admin/domain/add'); ?>" class="add-new">Add New Domain</a>
</div>

<table class="table">
    <thead>
        <tr>
            <th>Domain Name</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($domains as $domain): ?>
            <tr>
                <td><?= htmlspecialchars($domain['domain_name']); ?></td>
                <td>
                    <a href="<?= base_url("admin/domain/edit/{$domain['domain_id']}"); ?>" class="edit">Edit</a>
                    <a href="<?= base_url("admin/domain/delete/{$domain['domain_id']}"); ?>" class="delete"
                       onclick="return confirm('Are you sure you want to delete this domain?')">Delete</a>
                </td>
            </tr>
        <?php endforeach; ?>
    </tbody>
</table>

</body>
</html>
