<?php
if(!$this->session->userdata('id')) {
    redirect(base_url().'admin');
}
?>
<section class="content-header">
    <div class="content-header-left">
        <h1>Add News</h1>
    </div>
    <div class="content-header-right">
        <a href="<?php echo base_url(); ?>admin/news" class="btn btn-primary btn-sm">View All</a>
    </div>
</section>

<section class="content">
    <div class="row">
        <div class="col-md-12">
            <?php if ($this->session->flashdata('error')): ?>
                <div class="callout callout-danger">
                    <p><?php echo $this->session->flashdata('error'); ?></p>
                </div>
            <?php endif; ?>

            <?php if ($this->session->flashdata('success')): ?>
                <div class="callout callout-success">
                    <p><?php echo $this->session->flashdata('success'); ?></p>
                </div>
            <?php endif; ?>

            <?php echo form_open_multipart(base_url().'admin/news/add', ['class' => 'form-horizontal']); ?>
            <div class="box box-info">
                <div class="box-body">

                    <div class="form-group">
                        <label class="col-sm-2 control-label">News Title <span>*</span></label>
                        <div class="col-sm-6">
                            <input type="text" class="form-control" name="news_title" value="<?php echo set_value('news_title'); ?>">
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-sm-2 control-label">Stitle <span>*</span></label>
                        <div class="col-sm-6">
                            <input type="text" class="form-control" name="stitle" value="<?php echo set_value('stitle'); ?>">
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-sm-2 control-label">News Short Content <span>*</span></label>
                        <div class="col-sm-9">
                            <textarea class="form-control" name="news_content_short" style="height:80px;"><?php echo set_value('news_content_short'); ?></textarea>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-sm-2 control-label">News Content <span>*</span></label>
                        <div class="col-sm-9">
                            <textarea class="form-control editor" name="news_content"><?php echo set_value('news_content'); ?></textarea>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-sm-2 control-label">News Publish Date <span>*</span></label>
                        <div class="col-sm-2">
                            <input type="text" class="form-control" name="news_date" id="datepicker" value="<?php echo date('Y-m-d'); ?>"> (Format: yy-mm-dd)
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-sm-2 control-label">Select Category <span>*</span></label>
                        <div class="col-sm-3">
                            <select class="form-control select2" name="category_id">
                                <option value="">Select a category</option>
                                <?php foreach ($all_category as $row): ?>
                                    <option value="<?php echo $row['category_id']; ?>"><?php echo $row['category_name']; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-sm-2 control-label">Select Domain <span>*</span></label>
                        <div class="col-sm-3">
                            <select class="form-control select2" name="domain_id" required>
                                <option value="">Select a Domain</option>
                                <?php foreach ($all_domains as $domain): ?>
                                    <option value="<?php echo $domain['domain_id']; ?>"><?php echo $domain['domain_name']; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-sm-2 control-label">Comment <span>*</span></label>
                        <div class="col-sm-3">
                            <select class="form-control select2" name="comment">
                                <option value="On">On</option>
                                <option value="Off">Off</option>
                            </select>
                        </div>
                    </div>

                    <h3 class="seo-info">Photo and Banner</h3>
                    <div class="form-group">
                        <label class="col-sm-2 control-label">Featured Photo *</label>
                        <div class="col-sm-6">
                            <input type="file" name="photo">
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-sm-2 control-label">Banner *</label>
                        <div class="col-sm-6">
                            <input type="file" name="banner">
                        </div>
                    </div>

                    <h3 class="seo-info">SEO Information</h3>
                    <div class="form-group">
                        <label class="col-sm-2 control-label">Meta Title</label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" name="meta_title" value="<?php echo set_value('meta_title'); ?>">
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-sm-2 control-label">Meta Keywords</label>
                        <div class="col-sm-9">
                            <textarea class="form-control" name="meta_keyword" style="height:100px;"><?php echo set_value('meta_keyword'); ?></textarea>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-sm-2 control-label">Meta Description</label>
                        <div class="col-sm-9">
                            <textarea class="form-control" name="meta_description" style="height:100px;"><?php echo set_value('meta_description'); ?></textarea>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-sm-2 control-label">Title</label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" name="title" value="<?php echo set_value('title'); ?>">
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-sm-2 control-label">Encode Title</label>
                        <div class="col-sm-6">
                            <input type="text" class="form-control" name="encode_title" value="<?php echo set_value('encode_title'); ?>">
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-sm-2 control-label">Image Alt</label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" name="img_alt" value="<?php echo set_value('img_alt'); ?>">
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-sm-2 control-label">Language</label>
                        <div class="col-sm-2">
                            <select name="lang_id" class="form-control select2">
                                <?php foreach($all_lang as $row): ?>
                                    <option value="<?php echo $row['lang_id']; ?>"><?php echo $row['lang_name']; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
    <label class="col-sm-2 control-label">News Type <span>*</span></label>
    <div class="col-sm-3">
        <select class="form-control select2" name="type" required>
            <option value="business">Business</option>
            <option value="politics">Politics</option>
            <option value="fashion">Fashion</option>
        </select>
    </div>
</div>

                    <div class="form-group">
                        <label class="col-sm-2 control-label"></label>
                        <div class="col-sm-6">
                            <button type="submit" class="btn btn-success pull-left" name="form1">Submit</button>
                        </div>
                    </div>
                    
                </div>
            </div>
            <?php echo form_close(); ?>
        </div>
    </div>
</section>
