<?php
if(!$this->session->userdata('id')) {
	redirect(base_url().'admin');
}
?>

<section class="content-header">
	<div class="content-header-left">
		<h1>Add trending Table</h1>
	</div>
	<div class="content-header-right">
		<a href="<?php echo base_url(); ?>admin/pricing_table" class="btn btn-primary btn-sm">View All</a>
	</div>
</section>


<section class="content">
    <div class="row">
        <div class="col-md-12">

            <?php
            if ($this->session->flashdata('error')) {
                ?>
                <div class="callout callout-danger">
                    <p><?php echo $this->session->flashdata('error'); ?></p>
                </div>
                <?php
            }
            if ($this->session->flashdata('success')) {
                ?>
                <div class="callout callout-success">
                    <p><?php echo $this->session->flashdata('success'); ?></p>
                </div>
                <?php
            }
            ?>

            <?php echo form_open(base_url().'admin/pricing_table/add', array('class' => 'form-horizontal')); ?>
            <div class="box box-info">
                <div class="box-body">        
                    <!-- News Title -->
                    <div class="form-group">
                        <label for="" class="col-sm-2 control-label">News Title *</label>
                        <div class="col-sm-6">
                            <input type="text" autocomplete="off" class="form-control" name="news_title" value="<?php echo set_value('news_title'); ?>">
                        </div>
                    </div>

                    <!-- News Content -->
                    <div class="form-group">
                        <label for="" class="col-sm-2 control-label">News Content *</label>
                        <div class="col-sm-9">
                            <textarea class="form-control editor" name="news_content"><?php echo set_value('news_content'); ?></textarea>
                        </div>
                    </div>

                    <!-- Short News Content -->
                    <div class="form-group">
                        <label for="" class="col-sm-2 control-label">Short News Content *</label>
                        <div class="col-sm-9">
                            <textarea class="form-control" name="news_content_short"><?php echo set_value('news_content_short'); ?></textarea>
                        </div>
                    </div>

                    <!-- News Date -->
                    <div class="form-group">
                        <label for="" class="col-sm-2 control-label">News Date *</label>
                        <div class="col-sm-6">
                            <input type="date" autocomplete="off" class="form-control" name="news_date" value="<?php echo set_value('news_date'); ?>">
                        </div>
                    </div>

                    <!-- Photo -->
                    <div class="form-group">
                        <label for="" class="col-sm-2 control-label">Photo *</label>
                        <div class="col-sm-6">
                            <input type="file" class="form-control" name="photo">
                        </div>
                    </div>

                    <!-- Category -->
                    <div class="form-group">
                        <label for="" class="col-sm-2 control-label">Category *</label>
                        <div class="col-sm-6">
                            <select name="category_id" class="form-control select2">
                                <?php foreach ($all_categories as $category): ?>
                                    <option value="<?php echo $category['category_id']; ?>" <?php echo set_select('category_id', $category['category_id']); ?>>
                                        <?php echo $category['category_name']; ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>

                    <!-- Meta Title -->
                    <div class="form-group">
                        <label for="" class="col-sm-2 control-label">Meta Title *</label>
                        <div class="col-sm-6">
                            <input type="text" autocomplete="off" class="form-control" name="meta_title" value="<?php echo set_value('meta_title'); ?>">
                        </div>
                    </div>

                    <!-- Meta Keyword -->
                    <div class="form-group">
                        <label for="" class="col-sm-2 control-label">Meta Keyword *</label>
                        <div class="col-sm-6">
                            <input type="text" autocomplete="off" class="form-control" name="meta_keyword" value="<?php echo set_value('meta_keyword'); ?>">
                        </div>
                    </div>

                    <!-- Meta Description -->
                    <div class="form-group">
                        <label for="" class="col-sm-2 control-label">Meta Description *</label>
                        <div class="col-sm-6">
                            <input type="text" autocomplete="off" class="form-control" name="meta_description" value="<?php echo set_value('meta_description'); ?>">
                        </div>
                    </div>

                    <!-- Subtitle (stitle) -->
                    <div class="form-group">
                        <label for="" class="col-sm-2 control-label">Subtitle (stitle) *</label>
                        <div class="col-sm-6">
                            <input type="text" autocomplete="off" class="form-control" name="stitle" value="<?php echo set_value('stitle'); ?>">
                        </div>
                    </div>

                    <!-- Title -->
                    <div class="form-group">
                        <label for="" class="col-sm-2 control-label">Title *</label>
                        <div class="col-sm-6">
                            <input type="text" autocomplete="off" class="form-control" name="title" value="<?php echo set_value('title'); ?>">
                        </div>
                    </div>

                    <!-- Image Alt -->
                    <div class="form-group">
                        <label for="" class="col-sm-2 control-label">Image Alt *</label>
                        <div class="col-sm-6">
                            <input type="text" autocomplete="off" class="form-control" name="img_alt" value="<?php echo set_value('img_alt'); ?>">
                        </div>
                    </div>

                    <!-- Domain -->
                    <div class="form-group">
                        <label for="" class="col-sm-2 control-label">Domain *</label>
                        <div class="col-sm-6">
                            <select name="domain_id" class="form-control select2">
                                <?php foreach ($all_domains as $domain): ?>
                                    <option value="<?php echo $domain['domain_id']; ?>" <?php echo set_select('domain_id', $domain['domain_id']); ?>>
                                        <?php echo $domain['domain_name']; ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>

                    <!-- Encoded Title -->
                    <div class="form-group">
                        <label for="" class="col-sm-2 control-label">Encoded Title (Encode Title) *</label>
                        <div class="col-sm-6">
                            <input type="text" autocomplete="off" class="form-control" name="encode_title" value="<?php echo set_value('encode_title'); ?>">
                        </div>
                    </div>

                    <!-- Submit Button -->
                    <div class="form-group">
                        <label for="" class="col-sm-2 control-label"></label>
                        <div class="col-sm-6">
                            <button type="submit" class="btn btn-success pull-left" name="form1">Submit</button>
                        </div>
                    </div>
                </div>
            </div>
            <?php echo form_close(); ?>
        </div>
    </div>
</section>
