<section class="content-header">
	<div class="content-header-left">
		<h1>Edit pricing Table</h1>
	</div>
	<div class="content-header-right">
		<a href="<?php echo base_url(); ?>admin/pricing_table" class="btn btn-primary btn-sm">Back to List</a>
	</div>
</section>

<section class="content">
	<div class="row">
		<div class="col-md-12">
			<?php if ($this->session->flashdata('error')) { ?>
				<div class="callout callout-danger">
					<p><?php echo $this->session->flashdata('error'); ?></p>
				</div>
			<?php } ?>
			<?php if ($this->session->flashdata('success')) { ?>
				<div class="callout callout-success">
					<p><?php echo $this->session->flashdata('success'); ?></p>
				</div>
			<?php } ?>

			<form action="" method="POST" enctype="multipart/form-data">
				<div class="box box-info">
					<div class="box-body">
						<!-- News Title -->
						<div class="form-group">
							<label for="news_title">News Title</label>
							<input type="text" class="form-control" id="news_title" name="news_title"
								value="<?php echo set_value('news_title', $trending_table['news_title']); ?>">
						</div>

						<!-- News Content -->
						<div class="form-group">
							<label for="news_content">News Content</label>
							<textarea class="form-control" id="news_content"
								name="news_content"><?php echo set_value('news_content', $trending_table['news_content']); ?></textarea>
						</div>

						<!-- Short News Content -->
						<div class="form-group">
							<label for="news_content_short">Short News Content</label>
							<textarea class="form-control" id="news_content_short"
								name="news_content_short"><?php echo set_value('news_content_short', $trending_table['news_content_short']); ?></textarea>
						</div>

						<!-- News Date -->
						<div class="form-group">
							<label for="news_date">News Date</label>
							<input type="date" class="form-control" id="news_date" name="news_date"
								value="<?php echo set_value('news_date', $trending_table['news_date']); ?>">
						</div>

						<!-- Photo -->
						<div class="form-group">
							<label for="photo">Photo</label>
							<input type="file" class="form-control" id="photo" name="photo">

							<?php if (!empty($trending_table['photo'])): ?>
								<img src="<?php echo base_url('public/uploads/' . $trending_table['photo']); ?>" width="100"
									alt="Photo for <?php echo $trending_table['news_title']; ?>">
								<div class="image-alt-text">
									<?php echo $trending_table['photo']; ?>
								</div>
							<?php endif; ?>
						</div>

						<!-- Category Selection -->
						<div class="form-group">
							<label for="category_id" class="col-sm-2 control-label text-right">Category :</label>
							<div class="col-sm-10">
								<select name="category_id" class="form-control select2" id="category_id">
									<?php foreach ($all_categories as $category): ?>
										<option value="<?php echo $category['category_id']; ?>" <?php echo set_select('category_id', $category['category_id'], $trending_table['category_id'] == $category['category_id']); ?>>
											<?php echo $category['category_name']; ?>
										</option>
									<?php endforeach; ?>
								</select>
							</div>
						</div>



						<!-- Meta Title -->
						<div class="form-group">
							<label for="meta_title">Meta Title</label>
							<input type="text" class="form-control" id="meta_title" name="meta_title"
								value="<?php echo set_value('meta_title', $trending_table['meta_title']); ?>">
						</div>

						<!-- Meta Keyword -->
						<div class="form-group">
							<label for="meta_keyword">Meta Keyword</label>
							<input type="text" class="form-control" id="meta_keyword" name="meta_keyword"
								value="<?php echo set_value('meta_keyword', $trending_table['meta_keyword']); ?>">
						</div>

						<!-- Meta Description -->
						<div class="form-group">
							<label for="meta_description">Meta Description</label>
							<textarea class="form-control" id="meta_description"
								name="meta_description"><?php echo set_value('meta_description', $trending_table['meta_description']); ?></textarea>
						</div>

						<!-- Subtitle -->
						<div class="form-group">
							<label for="stitle">Subtitle</label>
							<input type="text" class="form-control" id="stitle" name="stitle"
								value="<?php echo set_value('stitle', $trending_table['stitle']); ?>">
						</div>

						<!-- Title -->
						<div class="form-group">
							<label for="title">Title</label>
							<input type="text" class="form-control" id="title" name="title"
								value="<?php echo set_value('title', $trending_table['title']); ?>">
						</div>

						<!-- Image Alt -->
						<div class="form-group">
							<label for="img_alt">Image Alt</label>
							<input type="text" class="form-control" id="img_alt" name="img_alt"
								value="<?php echo set_value('img_alt', $trending_table['img_alt']); ?>">
						</div>

						<div class="form-group">
							<label for="domain_id" class="col-sm-2 control-label text-right">Domain :</label>
							<div class="col-sm-10">
								<select name="domain_id" class="form-control select2" id="domain_id">
									<?php foreach ($all_domains as $domain): ?>
										<option value="<?php echo $domain['domain_id']; ?>" <?php echo set_select('domain_id', $domain['domain_id'], $trending_table['domain_id'] == $domain['domain_id']); ?>>
											<?php echo $domain['domain_name']; ?>
										</option>
									<?php endforeach; ?>
								</select>
							</div>
						</div>


						<!-- Encode Title -->
						<div class="form-group">
							<label for="encode_title">Encode Title</label>
							<input type="text" class="form-control" id="encode_title" name="encode_title"
								value="<?php echo set_value('encode_title', $trending_table['encode_title']); ?>">
						</div>

						<!-- Submit Button -->
						<button type="submit" name="form1" class="btn btn-primary">Save Changes</button>
					</div>
				</div>
			</form>
		</div>
	</div>
</section>